/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ability;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import noppes.npcs.ability.IAbility;
import noppes.npcs.constants.EnumAbilityType;
import noppes.npcs.entity.EntityNPCInterface;

public abstract class AbstractAbility
implements IAbility {
    private long cooldown = 0L;
    public float maxHP = 1.0f;
    public float minHP = 1.0f;
    protected EntityNPCInterface npc;

    public AbstractAbility(EntityNPCInterface npc) {
        this.npc = npc;
    }

    @Override
    public boolean canRun(EntityLivingBase target) {
        if (this.onCooldown()) {
            return false;
        }
        float f = this.npc.func_110143_aJ() / this.npc.func_110138_aP();
        return f >= this.minHP && f <= this.maxHP && (this.getRNG() <= 1 || this.npc.func_70681_au().nextInt(this.getRNG()) == 0) && this.npc.func_70685_l((Entity)target);
    }

    @Override
    public void endAbility() {
        this.cooldown = System.currentTimeMillis() + (long)this.npc.ais.getMaxHurtResistantTime() * 1000L;
    }

    @Override
    public int getRNG() {
        return 0;
    }

    public abstract boolean isType(EnumAbilityType var1);

    private boolean onCooldown() {
        return System.currentTimeMillis() < this.cooldown;
    }

    @Override
    public void startCombat() {
        this.cooldown = System.currentTimeMillis() + (long)this.npc.ais.getMaxHurtResistantTime() * 1000L;
    }
}

